/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVehicle;
import org.bukkit.entity.EntityType;

public class CraftBoat
extends CraftVehicle
implements org.bukkit.entity.Boat {
    public CraftBoat(CraftServer server, Boat entity) {
        super(server, (Entity)entity);
    }

    @Override
    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().m_38387_());
    }

    @Override
    public void setWoodType(TreeSpecies species) {
        this.getHandle().m_38332_(CraftBoat.getBoatType(species));
    }

    @Override
    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    @Override
    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    @Override
    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    @Override
    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    @Override
    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    @Override
    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    @Override
    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    @Override
    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat getHandle() {
        return (Boat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat";
    }

    @Override
    public EntityType getType() {
        return EntityType.BOAT;
    }

    public static TreeSpecies getTreeSpecies(Boat.Type boatType) {
        switch (boatType) {
            case SPRUCE: {
                return TreeSpecies.REDWOOD;
            }
            case BIRCH: {
                return TreeSpecies.BIRCH;
            }
            case JUNGLE: {
                return TreeSpecies.JUNGLE;
            }
            case ACACIA: {
                return TreeSpecies.ACACIA;
            }
            case DARK_OAK: {
                return TreeSpecies.DARK_OAK;
            }
        }
        return TreeSpecies.GENERIC;
    }

    public static Boat.Type getBoatType(TreeSpecies species) {
        switch (species) {
            case REDWOOD: {
                return Boat.Type.SPRUCE;
            }
            case BIRCH: {
                return Boat.Type.BIRCH;
            }
            case JUNGLE: {
                return Boat.Type.JUNGLE;
            }
            case ACACIA: {
                return Boat.Type.ACACIA;
            }
            case DARK_OAK: {
                return Boat.Type.DARK_OAK;
            }
        }
        return Boat.Type.OAK;
    }
}

